function [price_matrix, true_value] = Optimization_Phase(C, S, pmin, pmax, h, beta)
% Computes the value function matrix V(c,s) using dynamic programming,
% where c is the remaining capacity and s the time period, and
% returns the corresponding optimal prices
%
% Inputs: 
%   C: Total capacity.
%   S: Number of time periods in each selling season.
%   pmin, pmax: Minimum and maximum prices.
%   h: Function handle for demand probability.
%   beta: Vector of parameter estimates of the demand function.
%
% Outputs:
%   price_matrix: Matrix of optimal prices for each value of
%   remaining capacity and time period

% Initialize the value function matrix
V = zeros(C+1, S+1);

% Initialize the price matrix
price_matrix = zeros(C+1, S);

options = optimset('MaxFunEvals',200*length(beta));

% Compute the value function
for s = S:-1:1
    for c = 1:C+1 % capacity from 0 to C
        % Compute the optimal price
        pstar = fminbnd(@(p) -Value_Function(p, c, s, V, h, beta, S), pmin, pmax, options);
        % Update the value function
        V(c,s) = Value_Function(pstar, c, s, V, h, beta, S);
        price_matrix(c,s) = pstar;
    end
end

true_value = V(C+1,1);

end